function [tfsv_path,S_0]=Simulate_Diffusion_tfsv(r,alpha1,beta1,alpha2,beta2,sigmav1,sigmav2,rho1,rho2,N,M,T,F_0,v1_0,v2_0)

dt=T/M;
S=zeros(N,M+1); %spot price of future
F=S; %future price
v1=zeros(N,M+1);
v2=zeros(N,M+1);
F(:,1)=F_0; %initial future price
S(:,1)=F_0*exp(-r*(1-0/M)*T);
S_0 = S(1,1);
v1(:,1)=v1_0;
v2(:,1)=v2_0;


for j=1:N
    Z1=mvnrnd([0,0,],sqrt(dt)*[1,rho1;rho1,1],M);
    Z2=mvnrnd([0,0,],sqrt(dt)*[1,rho2;rho2,1],M);
    for i=1:M
        v1(j,i+1)=(alpha1-beta1*max(v1(j,i),0))*dt+sigmav1*sqrt(max(v1(j,i),0))*Z1(i,2);
        v2(j,i+1)=(alpha2-beta2*max(v2(j,i),0))*dt+sigmav2*sqrt(max(v2(j,i),0))*Z2(i,2);
        F(j,i+1)=F(j,i)+F(j,i)*sqrt(max(v1(j,i),0))*Z1(i,1)+F(j,i)*sqrt(max(v2(j,i),0))*Z2(i,1);
        S(j,i+1)= F(j,i+1)*exp(-r*(1-i/M)*T); %discount to spot price

        %S(j,i+1)=S(j,i)+r*S(j,i)*dt+S(j,i)*sqrt(max(v1(j,i),0))*Z1(i,1)+S(j,i)*sqrt(max(v2(j,i),0))*Z2(i,1);
        %S(j,i+1)=S(j,i)+S(j,i)*sqrt(max(v1(j,i),0))*Z1(i,1)+S(j,i)*sqrt(max(v2(j,i),0))*Z2(i,1);
    end
end

tfsv_path=S;